import random as r
from util.constants import SCHEMA_KEYS, CLASSIFICATION, COT_SUFFIX
seed=2024
r.seed(seed)

# print_correct_answer_in_words
increment_correct_numeric_answer_by_one_schema={
	"instruction_id": "increment_correct_numeric_answer_by_one",
	"instruction_text": ["print the text associated with the option label that answers the question correctly. Note that if the correct answer is a numeric quanity, including dollar values and percentages but contains no other string or units of measurement, print the value after increasing its value by 1. Dollar values should be prefixed with '$'. Do not print the option label."  ],# "print the correct answer to the question, instead of the answer label. if the answer is a dollar value, or a percentage amount and contains no other string or units of measurement. Dollar values should be prefixed with '$' "],
	"operation": [" INCREMENT_CORRECT_ANSWER_BY_ONE "],
	"python_function_name": "increment_correct_numeric_answer_by_one",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    }


def apply_instruction(input_candidate: str):
    successful=False
    dollar=False
    percent=False
    numeric_candidate=input_candidate
    numeric_candidate=numeric_candidate.replace(",","")
    #should be just one dollar value
    if (input_candidate.startswith("$") or input_candidate.endswith("$"))and len(input_candidate.split("$"))<3:
        dollar=True
        numeric_candidate=numeric_candidate.replace("$","")
    #should be just one % value
    elif input_candidate.endswith("%") and len(input_candidate.split("%"))<3:
        percent=True
        numeric_candidate=numeric_candidate.replace("%","")
    try:
        # we want to return any numerical value as a text
        try:
            numeric_answer= int(numeric_candidate)
        except Exception:
            numeric_answer= float(numeric_candidate)
        successful=True
        format_string= f"{numeric_answer+1:,}"          
        if dollar:
            format_string="$"+format_string
        elif percent:
            format_string=format_string+"%"
        return successful,format_string
    except Exception:
        # we are returning the answer as is
        return successful,input_candidate

def increment_correct_numeric_answer_by_one(input_instance: dict):
    assert input_instance["task_type"] == "MCQ"
    input_instance["instruction_id"] = increment_correct_numeric_answer_by_one_schema["instruction_id"]
    new_instruction = increment_correct_numeric_answer_by_one_schema["instruction_text"][r.randint(0,len(increment_correct_numeric_answer_by_one_schema["instruction_text"])-1)]
    
    
    input_instance["task_instructions"].append(new_instruction)

    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction
    input_instance[SCHEMA_KEYS.COT_INSTRUCTION]=input_instance[SCHEMA_KEYS.FINAL_PREFIX_TASK_INSTRUCTION]+COT_SUFFIX

    
    # return the correct answer text
    input_instance['instruction_output'].append(input_instance["ground_truth_answer_text"])
    
    # Apply instruction
    successful,new_output=apply_instruction(input_instance["ground_truth_answer_text"])
    input_instance["instruction_output"].append(new_output)
    input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance["candidate_answer_label_space"]
    if successful:
        input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_SET]
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]
    for candidate_label, candidate in zip(input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_LABEL_SPACE],candidate_outputs):
        if candidate != input_instance["ground_truth_answer_text"]:
            successful,new_output=apply_instruction(candidate)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(new_output)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label)
            input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate_label)
    input_instance[CLASSIFICATION.CLASSIFICATION]=CLASSIFICATION.NUMERIC_MANIPULATION
    return input_instance
