import random as r
import copy
from util.constants import SCHEMA_KEYS, CLASSIFICATION, COT_SUFFIX

seed=2024
r.seed(seed)

# sort only incorrect answers; assuming no options are lists themeselves
sort_only_incorrect_answers_schema={
	"instruction_id": "sort_only_incorrect_answers",
	"instruction_text": ["excluding the option that answers the question correctly, print a sorted list (ascending order) of the incorrect options. Do not print the option labels. Use the text associated with the option labels and not the option labels while sorting and printing.", "excluding the option that answers the question correctly, print a sorted list (ascending order) of the incorrect options.  Do not print the option labels. Use the text associated with the option labels and not the option labels while sorting and printing.", "excluding the option that answers the question correctly, print a sorted list (ascending order) of the incorrect options. Do not print the option labels. Use the text associated with the option labels and not the option labels while sorting and printing."],
	"operation": [" SORT_INCORRECT "],
	"python_function_name": "sort_only_incorrect_answers",
	"python_args": "instruction_instance",
	"target_answer_return_type": "list"
    }

def apply_instruction(input_candidate: str, candidate_answer_set: list):
    templist=copy.deepcopy(candidate_answer_set)
    templist.remove(input_candidate)
    templist.sort(reverse=False)
    return str(templist)
    
def sort_only_incorrect_answers(input_instance: dict):
    assert input_instance["task_type"] == "MCQ"
    input_instance["instruction_id"] = sort_only_incorrect_answers_schema["instruction_id"]
    new_instruction = sort_only_incorrect_answers_schema["instruction_text"][r.randint(0,len(sort_only_incorrect_answers_schema["instruction_text"])-1)]
    
    # we add reversing correct answer instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)

    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction
    input_instance[SCHEMA_KEYS.COT_INSTRUCTION]=input_instance[SCHEMA_KEYS.FINAL_PREFIX_TASK_INSTRUCTION]+COT_SUFFIX

    input_instance['instruction_output'].append(apply_instruction(input_instance['ground_truth_answer_text'], input_instance['candidate_answer_set']))
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]

    input_instance[CLASSIFICATION.CLASSIFICATION]=CLASSIFICATION.LIST_MANIPULATION
    return input_instance
