import random as r
import copy

seed=2024
r.seed(seed)

# sort all the candidate answer and print using numbered list
sort_options_to_create_numbered_list_schema={
	"instruction_id": "sort_options_to_create_numbered_list",
	"instruction_text": ["sort the list of options using their values, in alphabetical order. Print the sorted list, with each element of the list on a new line, by a number and a period (1., 2., and so on). Do not print the option label. Remember to use only the text associated with the option labels and not the option labels while sorting and printing."],#"Sort the list of strings alphabetically, then return a string with each item on a new line, prefixed by a number and a period (1., 2., etc.).", "Arrange the strings in alphabetical order and create a string where each string is on its own line, beginning with a number and a period (1., 2., etc.).", "Sort the strings alphabetically and generate a string where each item is listed on a new line with a preceding numeral and a period (1., 2., etc.)."],
	"operation": [" SORT_OPTIONS_TO_NUMBERED_LIST "],
	"python_function_name": "sort_options_to_create_numbered_list",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    }

def apply_instruction(candidate_answer_set: list):
    # Sort the list alphabetically
    sorted_strings = sorted(candidate_answer_set)
    
    # Create the numbered list as a single string
    numbered_list = "\n".join(f"{index}. {string}" for index, string in enumerate(sorted_strings, start=1))
    
    return numbered_list


def sort_options_to_create_numbered_list(input_instance: dict):
    new_instruction = sort_options_to_create_numbered_list_schema["instruction_text"][r.randint(0,len(sort_options_to_create_numbered_list_schema["instruction_text"])-1)]
    
    # we add the numbered list instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)

    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction

    input_instance['instruction_output'].append(apply_instruction(input_instance['candidate_answer_set']))
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]

    return input_instance
