import json
import argparse
import importlib

def main():
    parser = argparse.ArgumentParser(description='Test dataset loading')
    parser.add_argument('--dataset', help='Dataset name', required=True)
    from datasets import disable_caching
    disable_caching()
    args = parser.parse_args()

    module = importlib.import_module(f"data_transform.hf_schema_transformer.{args.dataset}")
    class_def = getattr(module, args.dataset)

    dataset = class_def()

    intermediate_rep_datasets = [dataset_name for dataset_name in dataset.intermediate_representation["dataset"]]
    unique_datasets = list(dict.fromkeys(intermediate_rep_datasets))

    if len(unique_datasets) == 1:
        print("Printing an instance...")
        example = dataset.intermediate_representation[0]
        print(json.dumps(example, indent=4))
    else:
        print(f"Printing {len(unique_datasets)} instances of unique datasets...")
        for unique_data in unique_datasets:
            idx = intermediate_rep_datasets.index(unique_data)
            example = dataset.intermediate_representation[idx]
            print(json.dumps(example, indent=4))


if __name__ == "__main__":
    main()
