import random as r
from util.constants import SCHEMA_KEYS, CLASSIFICATION, COT_SUFFIX, COT_SUFFIX

seed=2024
r.seed(seed)

# alternate_case_correct_answer
alternate_case_correct_answer_schema = [
    {
	"instruction_id": "alternate_case_correct_answer",
	"instruction_text": ["answer the question by printing the text associated with the correct option label in alternate case. The first character should be in uppercase and the following characters should alternate between lowercase and uppercase. Do not print the option label."],
	"operation": [" ALT_CASE "],
	"python_function_name": "alternate_case_correct_answer",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    },
]

def apply_instruction(input_candidate: str):
    alternate_case_correct_answer = [ele.upper() if not idx % 2 else ele.lower() for idx, ele in enumerate(input_candidate)]
    alternate_case_correct_answer = "".join(alternate_case_correct_answer)
    return alternate_case_correct_answer

def apply_instruction_incorrect(input_candidate: str):
    alternate_case_correct_answer = [ele.upper() if idx % 2 else ele.lower() for idx, ele in enumerate(input_candidate)]
    alternate_case_correct_answer = "".join(alternate_case_correct_answer)
    return alternate_case_correct_answer
    
def alternate_case_correct_answer(input_instance: dict):
    assert input_instance["task_type"] == "MCQ"
    input_instance["instruction_id"] = alternate_case_correct_answer_schema[0]["instruction_id"]
    new_instruction = alternate_case_correct_answer_schema[0]["instruction_text"][r.randint(0,len(alternate_case_correct_answer_schema[0]["instruction_text"])-1)]
    
    # we add alternating correct answer instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)

    # we add alternating correct answer instruction to the instruction list
    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction
    input_instance[SCHEMA_KEYS.COT_INSTRUCTION]=input_instance[SCHEMA_KEYS.FINAL_PREFIX_TASK_INSTRUCTION]+COT_SUFFIX

    # convert output to alternate case
    instr_output_correct_answer = apply_instruction(input_instance["ground_truth_answer_text"])
    input_instance['instruction_output'].append(instr_output_correct_answer)
    input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_LABEL_SPACE]
    #input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_SET]
    
    input_instance[CLASSIFICATION.CLASSIFICATION]=CLASSIFICATION.STRING_MANIPULATION
   
    # convert candidate outputs to alternate case
    candidate_outputs = input_instance["candidate_answer_set"]
    candidate_outputs_after_instruction = []
    for candidate_label, candidate in zip(input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_LABEL_SPACE],candidate_outputs):
        input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(apply_instruction_incorrect(candidate))
        if candidate != input_instance["ground_truth_answer_text"]:
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(apply_instruction(candidate))
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label)
        else:
            if all(x.isalpha() or x.isspace() for x in candidate) and len(candidate)>1:
                input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate.lower())
                input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate.upper())
                input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate)

    return input_instance
