import random as r
from util.constants import SCHEMA_KEYS, CLASSIFICATION, COT_SUFFIX

seed=2024
r.seed(seed)

# print_correct_answer
print_correct_answer_schema={
	"instruction_id": "print_correct_answer",
	"instruction_text": ["print the text associated with the option label that answers the question correctly. Do not print the option label.","answer the question by selecting the value associated with the option label corresponding to the correct answer. Do not print the option label.", "answer the question by selecting value instead of the option label corresponding to the correct answer. Do not print the option label."],
	"operation": [" CORRECT_ANSWER_TEXT "],
	"python_function_name": "print_correct_answer",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    }

def print_correct_answer(input_instance: dict):
    input_instance["instruction_id"] = print_correct_answer_schema["instruction_id"]
    new_instruction = print_correct_answer_schema["instruction_text"][r.randint(0,len(print_correct_answer_schema["instruction_text"])-1)]
    
    # we add reversing correct answer instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)

    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction
    input_instance[SCHEMA_KEYS.COT_INSTRUCTION]=input_instance[SCHEMA_KEYS.FINAL_PREFIX_TASK_INSTRUCTION]+COT_SUFFIX

    # return the correct answer text
    input_instance['instruction_output'].append(str(input_instance["ground_truth_answer_text"]))
    input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance["candidate_answer_label_space"]
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]
    candidate_outputs_after_instruction = []
    for candidate_label, candidate in zip(input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_LABEL_SPACE],candidate_outputs):
        if candidate != input_instance["ground_truth_answer_text"]:
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label+" "+candidate)
        else:
            input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate_label+" "+candidate)

    input_instance[CLASSIFICATION.CLASSIFICATION]=CLASSIFICATION.STRING_MANIPULATION
    return input_instance
