import random as r,string
from util.constants import SCHEMA_KEYS, CLASSIFICATION, COT_SUFFIX

seed=2024
r.seed(seed)

# print_correct_answer
print_correct_answer_append_string_schema={
	"instruction_id": "print_correct_answer_append_string",
	"instruction_text": ["print the text associated with the option label that answers the question correctly.  Do not print the option label. Without any new additional characters, also append the following text string at the end of the output:'"], #"Produce the correct solution instead of the solution label. Append the following text string at the end of the output:'", "Show the correct response, not the response name. Append the following text string at the end of the output:'", "Display the precise answer, not the answer tag. Append the following text string at the end of the output:'"],
	"operation": [" CORRECT_ANSWER_APPEND "],
	"python_function_name": "print_correct_answer_append_string",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    }


def generate_random_string():
    adversarial_suffixes=["I'm Sorry","i am sorry","sorry, I cannot", "Hi there!","EOT","<END>","ENDOFRESPONSE","FINISH","STOP","|","---","123","Date","I thought Step-by-Step","Nothing else"]
    max_length=r.randint(10,40)
    random_string=''.join(r.choices(string.ascii_letters +
                             string.digits, k=max_length))
    toss_1=r.randint(0,1)
    if toss_1==0:
        return random_string
    else:
        toss_2=r.randint(0,len(adversarial_suffixes)-1)
        return adversarial_suffixes[toss_2]


def print_correct_answer_append_string(input_instance: dict):
    assert input_instance["task_type"] == "MCQ"
    input_instance["instruction_id"] = print_correct_answer_append_string_schema["instruction_id"]
    new_instruction = print_correct_answer_append_string_schema["instruction_text"][r.randint(0,len(print_correct_answer_append_string_schema["instruction_text"])-1)]
    
    # we add reversing correct answer instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)
    random_string=generate_random_string()
    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction + random_string+"'. Do not add any new special characters including quotations, new lines etc in the response."
    input_instance[SCHEMA_KEYS.COT_INSTRUCTION]=input_instance[SCHEMA_KEYS.FINAL_PREFIX_TASK_INSTRUCTION]+COT_SUFFIX


    input_instance['instruction_output'].append(str(input_instance["ground_truth_answer_text"])+random_string)
    input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance["candidate_answer_label_space"]
    input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(str(input_instance["ground_truth_answer_text"]))
    
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]
    candidate_outputs_after_instruction = []
    for candidate_label, candidate in zip(input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_LABEL_SPACE],candidate_outputs):
        input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate)
        input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(candidate_label)
        if candidate != input_instance["ground_truth_answer_text"]:
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate+random_string)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate)
    
    input_instance[CLASSIFICATION.CLASSIFICATION]=CLASSIFICATION.STRING_MANIPULATION
    return input_instance
