import random as r
from util.constants import SCHEMA_KEYS, CLASSIFICATION, COT_SUFFIX
from num2words import num2words as nw

seed=2024
r.seed(seed)

# print_correct_answer_in_words
print_correct_answer_in_words_schema={
	"instruction_id": "print_correct_answer_in_words",
	"instruction_text": ["print the text associated with the option label that answers the question correctly.  However, if the correct answer is a numeric value with no additional text (including percentages, currency, units of measurement etc), print the numeric answer in words. For example, if the answer is '32' print 'thirty-two' without quotes. Do not print the option label.", "print the text associated with the option label that answers the question correctly. However, if the correct answer is a numeric value with no additional text (including percentages, currency, units of measurement etc), ensure that the numeric answer values are returned in words. For example, if the answer is '32' print 'thirty-two' without quotes. Do not print the option label.",],# "Display the precise answer, not the answer tag. If the answer is numeric value with no additional text (including percentages, currency, units of measurement etc), print the answer in words."],
	"operation": [" CORRECT_ANSWER_WORDS "],
	"python_function_name": "print_correct_answer_in_words",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    }

def apply_instruction(input_candidate: str):
    successful=False
    try:
        # we want to return any numerical value as a text
        numeral_answer_in_words = nw(input_candidate)
        successful=True
        return successful,numeral_answer_in_words
    except Exception as e:
        # we are returning the answer as is
        return successful,input_candidate

def print_correct_answer_in_words(input_instance: dict):
    assert input_instance["task_type"] == "MCQ"

    input_instance["instruction_id"] = print_correct_answer_in_words_schema["instruction_id"]
    new_instruction = print_correct_answer_in_words_schema["instruction_text"][r.randint(0,len(print_correct_answer_in_words_schema["instruction_text"])-1)]
    
    # we add reversing correct answer instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)

    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction
    input_instance[SCHEMA_KEYS.COT_INSTRUCTION]=input_instance[SCHEMA_KEYS.FINAL_PREFIX_TASK_INSTRUCTION]+COT_SUFFIX


    # return the correct answer text
    input_instance['instruction_output'].append(input_instance["ground_truth_answer_text"])
    input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance["candidate_answer_label_space"]
    successful, new_output =apply_instruction(input_instance['ground_truth_answer_text'])
    input_instance["instruction_output"].append(new_output)
    if successful:
        input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_SET]
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]
    for candidate_label, candidate in zip(input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_LABEL_SPACE],candidate_outputs):
        if candidate != input_instance["ground_truth_answer_text"]:
            successful, new_output = apply_instruction(candidate)
            if successful:
                input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(new_output)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label)
    input_instance[CLASSIFICATION.CLASSIFICATION]=CLASSIFICATION.NUMERIC_MANIPULATION
    return input_instance
