import random as r
from util.constants import SCHEMA_KEYS, CLASSIFICATION, COT_SUFFIX

seed=2024
r.seed(seed)

# reverse_correct_answer
reverse_correct_answer_schema={
	"instruction_id": "reverse_correct_answer",
	"instruction_text": ["answer the question by printing the text associated with the correct option label, in reverse. Do not print the option label."],# "Perform a string reversal of the correct answer", "Reverse the sequence of characters in the correct answer."],
	"operation": [" REVERSE_CORRECT_ANSWER "],
	"python_function_name": "reverse_correct_answer",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    }

def reverse_correct_answer(input_instance: dict):
    assert input_instance["task_type"] == "MCQ"
    input_instance["instruction_id"] = reverse_correct_answer_schema["instruction_id"]
    new_instruction = reverse_correct_answer_schema["instruction_text"][r.randint(0,len(reverse_correct_answer_schema["instruction_text"])-1)]
    
    # we add reversing correct answer instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)
    input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET]+=input_instance["candidate_answer_label_space"]
    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction
    input_instance[SCHEMA_KEYS.COT_INSTRUCTION]=input_instance[SCHEMA_KEYS.FINAL_PREFIX_TASK_INSTRUCTION]+COT_SUFFIX
    if isinstance(input_instance["ground_truth_answer_text"],list):
         input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(str(input_instance["ground_truth_answer_text"][0]))
         input_instance['instruction_output'].append(str(input_instance["ground_truth_answer_text"][0][::-1]))
    else:
        
        input_instance[SCHEMA_KEYS.INSTRUCTION_FOLLOWING_ERRORS_SET].append(str(input_instance["ground_truth_answer_text"]))
        input_instance['instruction_output'].append(str(input_instance["ground_truth_answer_text"][::-1]))
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]
    gd=input_instance["ground_truth_answer_text"]
    if isinstance(gd,list):
        gd=gd[0]
    for candidate_label, candidate in zip(input_instance[SCHEMA_KEYS.CANDIDATE_ANSWER_LABEL_SPACE],candidate_outputs):
        if isinstance(candidate,list):
             candidate=candidate[0]
        if candidate != gd:
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate)
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate[::-1])
            input_instance[SCHEMA_KEYS.REASONING_ERROR_SET].append(candidate_label)
    

    input_instance[CLASSIFICATION.CLASSIFICATION]=CLASSIFICATION.STRING_MANIPULATION
    return input_instance
