import random as r
import copy

seed=2024
r.seed(seed)

# sort all the candidate answer and print using bulleted list
sort_options_to_create_bullet_list_schema={
	"instruction_id": "sort_options_to_create_bullet_list",
	"instruction_text": ["sort the list of options using their values, in alphabetical order. Print the sorted list, with each element of the list on a new line, prefixed by a bullet '-' (without quotes). Do not print the option labels. Remember to use only the text associated with the option labels and not the option labels while sorting and printing."],# "Sort the strings alphabetically and display the sorted list. Each string should be on a new line, starting with a dash (-).", "Organize the strings in alphabetical order, then output each one on a separate line with a hyphen (-) placed before each string."],
	"operation": [" SORT_OPTIONS_TO_BULLET_LIST "],
	"python_function_name": "sort_options_to_create_bullet_list",
	"python_args": "instruction_instance",
	"target_answer_return_type": "text"
    }

def apply_instruction(candidate_answer_set: list):
    # Sort the list
    candidate_answer_set.sort()
    
    # Return the list with bullets
    return "\n".join(f"- {item}" for item in candidate_answer_set)


def sort_options_to_create_bullet_list(input_instance: dict):
    new_instruction = sort_options_to_create_bullet_list_schema["instruction_text"][r.randint(0,len(sort_options_to_create_bullet_list_schema["instruction_text"])-1)]
    
    # we add the bullet list  instruction to the instruction list
    input_instance["task_instructions"].append(new_instruction)

    input_instance["final_prefix_task_instruction"] = input_instance["dataset_instruction"] + " " + new_instruction

    input_instance['instruction_output'].append(apply_instruction(input_instance['candidate_answer_set']))
    
    # apply instruction to all candidate outputs
    candidate_outputs = input_instance["candidate_answer_set"]

    return input_instance
