import json
import argparse
import importlib

def main():
    parser = argparse.ArgumentParser(description='Test script for adding instruction to dataset')
    parser.add_argument('--dataset', help='Dataset name', required=True)
    parser.add_argument('--instruction', help='Instruction name', required=True)

    args = parser.parse_args()

    module = importlib.import_module(f"data_transform.hf_schema_transformer.{args.dataset}")
    class_def = getattr(module, args.dataset)

    dataset = class_def()

    intermediate_rep_datasets = [dataset_name for dataset_name in dataset.intermediate_representation["dataset"]]
    unique_datasets = list(dict.fromkeys(intermediate_rep_datasets))
    
    print("Printing an instance...")
    example = dataset.intermediate_representation[0]
    print(json.dumps(example, indent=4))

    module = importlib.import_module(f"instructions.{args.instruction}")
    instruction_function = getattr(module, args.instruction)

    dataset.intermediate_representation = dataset.intermediate_representation.map(instruction_function, desc=f"Applying {args.instruction} transformation")
    
    if len(unique_datasets) == 1:
        print("Printing instances post instruction transformation...")
        for index in range(5):
            print("*" * 50)
            example = dataset.intermediate_representation[index]
            print(json.dumps(example, indent=4))
            print("-" * 50)
    else:
        print("Printing unique dataset instances post instruction transformation...")
        for unique_data in unique_datasets:
            idx = intermediate_rep_datasets.index(unique_data)
            example = dataset.intermediate_representation[idx]
            print(json.dumps(example, indent=4))

if __name__ == "__main__":
    main()
