function arf = FISTA(x0, ~, data, max_iters, tol)
% Nestorov's Fast Iterative Shrinkage-Thresholding Algorithm (FISTA)

% obtain data
grad = data.gradh; prox = data.prox; f = data.f; f_true = data.f_true;
L = data.L; grad = @(x) grad(x); 

% intialization
x = x0; y = x; t = 1; arf = zeros(max_iters+1,1);
f0 = f(x); g = grad(y); g0 = g; threshold = tol * norm(g0,"fro");
arf(1) = 1;
elapse = 0;

for iter = 1:max_iters
    tic;
    z = y - g/L;
    x_new = prox(z, 1/L);
    t_new = 0.5*(1+sqrt(1+4*t^2));
    y_new = x_new + ((t-1)/t_new)*(x_new-x);
    g_new = grad(y_new);
    arf(iter+1,:) = (f(x_new)-f_true)/(f0-f_true);
    t = toc; elapse = elapse + t;
    comp_grad_x = norm(grad(x_new)+L*(z-x_new));
    if norm(comp_grad_x,"fro") < threshold
        fprintf('FISTA converges after %d iterations.\n', iter);
        break;
    end
    x = x_new; y = y_new; t = t_new; g= g_new;
end

t = elapse;
fprintf("Elapsed time = %f.\n",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
end