function func = data_LASSO(n,p)
% f = h + g
% h = 0.5 * x' * A * x
% g = \lambda * norm(x,1)

    function x_prox = soft_thresholding(z, alpha)
        % Soft-thresholding (Proximal operator for L1 norm)
        x_prox = sign(z) .* max(abs(z) - lambda*alpha, 0);
    end

% p = 256; 
k = 50;
lambda = 1;
rng(42);
A = randn(n,p);
idx = randperm(p, k); % Random indices for nonzero elements
values = randn(k, 1); % Random nonzero values
x_true = sparse(idx, ones(k,1), values, p, 1);
b = A * x_true;
f_true = f(x_true);


U = A'*A;
L = max(eig(U));
mu = min(eig(U));

func = struct('n',n,'f',@f,'h',@h,'gradh',@grad,'prox',@soft_thresholding,'G',@G,'A',A,'b',b,'L',L,'mu',mu, 'f_true', f_true, 'x_true', x_true);

function y = h(x)
    y = 0.5*(A*x-b)'* (A*x-b);
end

function v = grad(x)
    v = A'*(A * x - b);
end

function z = G(x)
    z = lambda * norm(x,1);
end

function y = f(x)
    y = h(x) + G(x);
end
end