function func = data_LASSO_l1_l2(n,p)
% f = h + g
% h = 0.5 * x' * A * x
% g = \lambda * (norm(x,1) - norm(x,2) )

    function x = prox_l1_l2(v, lambda)
    % Soft-thresholding
        z = sign(v) .* max(abs(v) - lambda, 0);
        norm_z = norm(z, 2);
        
        if norm_z == 0
            x = zeros(size(v));
        else
            x = z / (1 + lambda / norm_z);
        end
    end

% p = 256; 
k = 50;
lambda = 1;
rng(42);
A = randn(n,p);
idx = randperm(p, k); % Random indices for nonzero elements
values = randn(k, 1); % Random nonzero values
x_true = sparse(idx, ones(k,1), values, p, 1);
b = A * x_true;
f_true = f(x_true);

U = A'*A;
L = max(eig(U));
mu = min(eig(U));

func = struct('n',n,'f',@f,'h',@h,'gradh',@grad,'prox',@prox_l1_l2,'G',@G,'A',A,'b',b,'L',L,'mu',mu,'f_true', f_true, 'x_true', x_true);

function y = h(x)
    y = 0.5*(A*x-b)'* (A*x-b);
end

function v = grad(x)
    v = A'*(A * x - b);
end

function z = G(x)
    z = lambda * ( norm(x,1) - norm(x,2) );
end

function y = f(x)
    y = h(x) + G(x);
end
end