function func = data_MaxLogLikelihood(n,M,kappa)
% min f(X) = -log(det(X)) + tr(XY)
% subject to \mu I <= X <= L I.

    function X_proj = prox_g(X, ~, lb, ub)
        % Compute eigen decomposition
        [U, D] = eig((X + X') / 2); % Ensure X is symmetric
        la = diag(D);
        
        % Clamp eigenvalues to [lb, ub]
        la_ = min(max(la, lb), ub);
        
        % Reconstruct the projected matrix
        X_proj = U * diag(la_) * U';
    end

rng(2);
lb = 1e-1;
% kappa = 100;
ub = lb * kappa;


y = randn(n,1)*10;
Y = zeros(n,n);
for i = 1:M
    y_ = y + randn(n, 1)*1; % Perturb y with a random vector
    Y = Y + (y_ * y_'); % Accumulate the outer product
end
Y = Y/M;

h = @(X) -log(det(X)) + trace(X*Y); 
grad = @(X) -inv(X) + Y;
G = @(X) 0;
f = @(X) h(X)+G(X);

prox = @(X,alpha) prox_g(X,alpha,lb,ub);
L = 1/lb^2; mu = 1/ub^2;

func = struct('n',n,'h',h,'gradh',grad,'G',G,'prox',prox,'f',f,'L',L,'mu',mu, 'ub',ub,'lb',lb);

end