% This script contains the test of the following composite problem:
% (1) Max Log Likelihood problem

rng(2);
colors = [0 0.2 0.6; 
      0 0 0;
      0.93 0.69 0.13;
      0.78 0.62 0.78];

%% Example 1: MLE problem
% n = 100; M = 50; kappa = 100;
n = 50; M = 100; kappa = 10000;
data = data_MaxLogLikelihood(n,M,kappa); 
tol = 1e-6; max_iters = 30000;
lb = data.lb; ub = data.ub; 
x0 = generate_spd(n,lb,ub); y0 = generate_spd(n,lb,ub);
%% calculate true solution and minimal value
x_final = reference_optimizer(x0, y0, data, 100000, 1e-10); data.f_true = data.f(x_final);
%% A2GD
figure;
[arf,gls] = A2GD_weaklyconvex_composite(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(1,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
ls = find(gls); vals = arf(ls);
semilogy(ls, vals, 'ro', 'MarkerSize', 2.5, 'MarkerFaceColor', 'r');
hold on;
%% AdProxGD
arf = AdProxGD(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(2,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%% FISTA
arf = FISTA(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(3,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%% AORHB
arf = AORHB_perturbed(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(4,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%% Plot Graph
xlim([1, 6000]);
ylim([1e-6, 1]);
hold off;
xlabel('Number of Gradient Evaluations'); ylabel('(f(x)-f*)/(f(x_0)-f*)');
legend('A$^2$GD','Line Search Step','AdProxGD','FISTA', ...
    'AORHB','Interpreter','latex','FontName','Times New Roman','FontSize',18); grid on;
ax = gca;
ax.FontSize = 20;