function x_final = reference_optimizer(x0, ~, data, max_iters, tol)
% Nestorov's Fast Iterative Shrinkage-Thresholding Algorithm (FISTA)

% obtain data
grad = data.gradh; prox = data.prox;
L = data.L; grad = @(x) grad(x);

% intialization
x = x0; y = x; t = 1;
g = grad(y); g0 = g; threshold = tol * norm(g0,"fro");
elapse = 0;

for iter = 1:max_iters
    z = y - g/L;
    x_new = prox(z, 1/L);
    t_new = 0.5*(1+sqrt(1+4*t^2));
    y_new = x_new + ((t-1)/t_new)*(x_new-x);
    g_new = grad(y_new);
    t = toc; elapse = elapse + t;
    comp_grad_x = norm(grad(x_new)+L*(z-x_new));
    if norm(comp_grad_x,"fro") < threshold
        break;
    end
    x = x_new; y = y_new; t = t_new; g= g_new;
end
x_final = x;
end