% This script contains the test of the following composite problem:
% (2) LASSO problem

rng(2);
colors = [0 0.2 0.6; 
      0 0 0;
      0.93 0.69 0.13;
      0.78 0.62 0.78];

%% Example 2: LASSO problem
n = 500;
p = 1000; 
data = data_LASSO(n,p);
x0 = 10*randn(p,1); y0 = 10*randn(p,1); 
max_iters = 10000; tol = 1e-6;

%% A2GD
figure;
[arf,gls] = A2GD_composite(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(1,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
ls = find(gls); vals = arf(ls);
semilogy(ls, vals, 'ro', 'MarkerSize', 2.5, 'MarkerFaceColor', 'r');
hold on;
%% AdProxGD
arf = AdProxGD(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(2,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%% FISTA
arf = FISTA(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(3,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%% AORHB
arf = AORHB_perturbed(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(4,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%% Plot Graph
xlim([1, 1000]);
ylim([1e-10, 1]);
hold off;
xlabel('Number of Gradient Evaluations'); ylabel('(f(x)-f*)/(f(x_0)-f*)');
legend('A$^2$GD','Grad Eval for Line Search','AdProxGD','NestorovAccGrad', ...
    'AOR-HB($\mu$)','AOR-HB($\mu/10$)','Interpreter','latex'); grid on;