function [values, x, num_oracles, total_time] = AC_FGM(prob, k, L_0, gamma, beta, alpha, x_0, eps, initial_line_search, adaptive_restart)

    if nargin < 10, adaptive_restart = false; end
    if nargin < 9, initial_line_search = true; end
    if nargin < 8, eps = 0; end
    if nargin < 7 || isempty(x_0), x = prob.x_0; else, x = x_0; end
    if nargin < 6 || isempty(alpha), alpha = 0.1; end
    if nargin < 5 || isempty(beta), beta = 0.184; end
    if nargin < 4 || isempty(gamma), gamma = prob.gamma; end

    if eps > 0
        fprintf('AC-FGM: k=%d, alpha=%.3f, beta=%.3f, eps=1e%d\n', k, alpha, beta, log10(eps));
    else
        fprintf('AC-FGM: k=%d, alpha=%.3f, beta=%.3f\n', k, alpha, beta);
    end

    tic;

    z = x;
    y = x;
    [f, obj, g] = prob.first_order_oracle(x); threshold = prob.tol*norm(g);
    values = obj;
    oracles = 1;
    num_oracles = oracles;

    if isempty(L_0)
        x_eps = x - 0.1 * ones(prob.d, 1);
        g_eps = prob.gradient(x_eps);
        L_0 = norm(g_eps - g) / norm(x_eps - x);
        oracles = oracles + 1;
    end

    if initial_line_search
        for i = 0:199
            L_new = 1.5^i * L_0 / 4;
            eta = 1 / (2.5 * L_new);
            x_new = prob.prox_mapping(x, eta * g, eta * gamma);
            [f_new, obj_new, g_new] = prob.first_order_oracle(x_new);
            oracles = oracles + 1;
            tmp1 = norm(g_new - g)^2 / (2 * L_new);
            tmp2 = L_new * norm(x_new - x)^2 / 2 + eps / 4;
            if tmp1 <= tmp2
                fprintf('Number of calls used for the initial linesearch: %d\n', i + 1);
                initial_eta = eta;
                break;
            end
        end

        if i == 199
            error('Need to rerun the linesearch.');
        end
    else
        L_new = L_0;
        eta = 1 / (2.5 * L_new);
        initial_eta = eta;
        x_new = prob.prox_mapping(x, eta * g, eta * gamma);
        [f_new, obj_new, g_new] = prob.first_order_oracle(x_new);
        oracles = oracles + 1;
    end

    x = x_new;
    z = x_new;
    L_e = L_new;
    f = f_new;
    g = g_new;
    values(end+1) = obj_new;
    num_oracles(end+1) = oracles;

    for t = 2:k
        if t == 2
            eta = min([(1 - beta) * eta, 1 / (4 * L_e)]);
            tau_old = 0;
            tau = 1;
        else
            eta = min([4/3 * eta, (tau_old + 1)/tau * eta, tau / (4 * L_e)]);
            tau_old = tau;
            tau = tau + 2 * (1 - alpha) * eta * L_e / tau + alpha / 2;
        end

        z = prob.prox_mapping(y, eta * g, eta * gamma);
        y = (1 - beta) * y + beta * z;
        x_new = (z + tau * x) / (1 + tau);
        [f_new, obj_new, g_new] = prob.first_order_oracle(x_new);
        oracles = oracles + 1;

        if norm(g_new - g) == 0
            L_e = 0;
        else
            L_e = norm(g_new - g)^2 / (2 * (f - f_new - g_new' * (x - x_new)) + eps / tau);
            if L_e < 0
                L_e = 0;
            end
        end

        if adaptive_restart && obj_new > obj
            tau_old = 0;
            tau = 1;
            eta = initial_eta;
            y = x_new;
        end

        obj = obj_new;
        f = f_new;
        g = g_new;
        x = x_new;

        values(end+1) = obj;
        num_oracles(end+1) = oracles;

        if norm(g)<=threshold
            fprintf('AC-FGM converges after %d iterations.\n', t);
            break;
        end
        fprintf('iter %d, error %f.\n', t, norm(g)/threshold * prob.tol);
    end

    total_time = toc;
    fprintf('Done: %.3f seconds\n', total_time);
    fprintf('-----------------------------------\n');

end
