function varargout = AORHB(x0, y0, data, max_iters, tol)

% obtain data
f = data.f; grad = data.gradf; L = data.L; mu = data.mu; %f_true = 0;
f_true = data.f_true;

% Initialization
x = x0; y = y0; g = grad(x); g0 = g; f0 = f(x0); 
threshold = norm(g0,"fro")*tol;
arf = zeros(max_iters+1,1); arf(1) = 1;
alpha = sqrt(mu/L);

tic;
for iter = 1:max_iters-1
    x_new = (x + alpha*y)/(1+alpha);
    g_new = grad(x_new);
    y_new = (y + alpha * x_new - alpha/mu*(2*g_new - g))/(1+alpha);
    x = x_new; y = y_new; g = g_new; fx = f(x);
    arf(iter+1) = (fx - f_true)/(f0 - f_true);
    fprintf('iter %d, error %f.\n', iter, arf(iter+1));
    if norm(g,"fro") < threshold
        fprintf('Converged after %d iterations.\n', iter);
        break;
    end
end

t = toc;
fprintf("Elapsed time = %f.",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
if nargout >= 1
    varargout{1} = arf;
end
if nargout >= 2
    varargout{2} = x_new;
end
end