function varargout = NAG(x0, ~, data,max_iters,tol)
% An implementation of Nestorov's method,
% x_{k+1} = x_k - h f'(y_k)
% y_{k+1} = x_{k+1} + \beta (x_{k+1}-x_k)
% where h = 1/L, and \beta = k/(k+3).

% obtain data
f = data.f; grad = data.gradf; L = data.L; f_true = data.f_true;

% intialization
x = x0; y = x0; g = grad(y); g0 = g; fx = f(x); f0 = fx;
arf = zeros(max_iters+1,1); arf(1,:) =1; threshold = norm(g0,"fro") * tol;

tic;
% assign parameters, all parameters fixed.
Lk = L; alpha = 1/Lk;
for iter = 1:max_iters
    beta = (iter - 1)/(iter + 2);
    x_new = y - alpha * g;
    y_new = x_new + beta * (x_new - x);
    x = x_new; y = y_new; fx = f(x); g = grad(y);
    arf(iter+1) = (fx-f_true)/(f0-f_true);
    if norm(g,"fro") < threshold
        fprintf('NAG converges after %d iterations.\n', iter);
        break;
    end
end
 

% outputs
t = toc;
fprintf("Elapsed time = %f.",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
if nargout >= 1
    varargout{1} = arf;
end
if nargout >= 2
    varargout{2} = x_new;
end
end