function varargout = NAGfree(x0, ~, data,max_iters,tol)
% An implementation of Algorithm 2 in [Cavalcanti et al. 2025]

% obtain data
f = data.f; grad = data.gradf; 
% L = data.L; 
f_true = data.f_true;

% intialization
x = x0; g = grad(x); g0 = g; fx = f(x); f0 = fx;
arf = zeros(max_iters+2,1); arf(1,:) =1; threshold = norm(g0,"fro") * tol;
y = x + rand(size(x))/(10^6); gy = grad(y); arf(2,:)=1;
Lk = norm(gy-g)/norm(x-y); muk = Lk;

tic;
% assign parameters, all parameters fixed.
for iter = 1:max_iters
    y_new = x - g/Lk;
    x_new = y_new + (y_new - y)*(sqrt(Lk)-sqrt(muk))/(sqrt(Lk)+sqrt(muk));
    g_new = grad(x_new);
    c_new = norm(g_new-g)/norm(x_new-x);
    Lk = max(Lk, c_new); muk = min(muk, c_new);
    x = x_new; y = y_new; fx = f(x); g = g_new;
    arf(iter+2) = (fx-f_true)/(f0-f_true);
    if norm(g,"fro") < threshold
        fprintf('NAGfree converges after %d iterations.\n', iter);
        break;
    end
end
 

% outputs
t = toc;
fprintf("Elapsed time = %f.",t);
fprintf("Minimum value of f(x): %f.\n", f(x_new));
arf = arf(1:iter+1);
if nargout >= 1
    varargout{1} = arf;
end
if nargout >= 2
    varargout{2} = x_new;
end
end