function arf = TM(x0, data, max_iters, tol)
% (Linear) conjugate gradint

% retrieve data
f = data.f; grad = data.gradf; f_true = data.f_true; 
kappa = data.kappa; L = data.L; rho = 1-1/sqrt(kappa);
alpha = (1+rho)/L; beta = rho^2/(2-rho); gamma = rho^2/((1+rho)*(2-rho)); delta = rho^2/(1-rho^2);

% intialization
x = x0; xi = x0; xiold = x0; y = x0; g = grad(y);
threshold = norm(g)*tol; f0 = f(x);
arf = zeros(max_iters+1,1); arf(1) = 1;

tic;
for iter = 1:max_iters

    y = (1+gamma) * xi - gamma * xiold;
    x = (1+delta) * xi - delta * xiold;
    g = grad(y);
    xi_new = (1+beta) * xi - beta * xiold - alpha * g;
    xiold = xi; xi = xi_new;
    arf(iter+1) = (f(x)-f_true)/(f0-f_true);
    if norm(g) < threshold
        fprintf('TM converges after %d iterations.', iter);
        break;
    end

end



% outputs
t = toc;
fprintf("Elapsed time = %f.\n",t);
fprintf("Minimum value of f(x): %f.\n", f(x));
arf = arf(1:iter+1);
end