function model = data_AdultCensusIncome()
    rng(2);  % For reproducibility

    T = readtable('adult.csv', 'TreatAsEmpty', '?');  % recognize '?' as missing
    T = rmmissing(T);
    T = convertvars(T, @iscellstr, @categorical);
    T = convertvars(T, @ischar, @categorical);
    T_numeric = varfun(@double, T);  % convert all to numeric
    X = T_numeric{:,1:end-1};  % feature matrix
    y = T_numeric{:,end};      % target column
    y = 2*(y == max(y)) - 1;   % ensures binary labels are ±1
    X = zscore(X);
    X = X';
    disp(size(X));
    n = size(X,1); p = size(X,2);

    B = zeros(n, n);
    for k = 1:p
        B = B + X(:, k) * X(:, k)';
    end
    mu = 0.1;
    L = eigs(B, 1) + mu;

    model = struct('n', n, 'mu', mu, 'L', L, 'gradf', @gradf, 'f', @f, 'p', p);

    %% Subfunction: logistic loss
    function z = f(x)
        z = mu/2 * (x' * x);
        for i = 1:p
            t = x' * X(:, i);
            z = z + log(1 + exp(-y(i) * t));
        end
    end

    %% Subfunction: gradient
    function z = gradf(x)
        z = mu * x;
        for i = 1:p
            t = x' * X(:, i);
            z = z + (exp(-y(i) * t) / (1 + exp(-y(i) * t))) * (-y(i) * X(:, i));
        end
    end
end
