% This script contains the test of the following smooth convex problem:
% (1) 2-D Laplace linear problem

colors = [0 0.2 0.6; 
      0 0 0;
      0.93 0.69 0.13;
      0.78 0.62 0.78;
      0.85 0.44 0.84;
      0 0.5 0;
      0.56, 0.93, 0.56];

%% Example 2'：
data = data_AdultCensusIncome(); n = data.n;
rng(2); x0 = rand(n,1); y0 = rand(n,1); 
max_iters = 2000; tol = 1e-6;
[soln, info] = reference_optimizer(data, 100000, x0, 1e-10);
data.f_true = data.f(soln.x);

%% A2GD_weaklyconvex
figure;
[arf,gls] = A2GD_weaklyconvex_new(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(1,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
ls = find(gls); vals = arf(ls);
semilogy(ls, vals, 'ro', 'MarkerSize', 2.5, 'MarkerFaceColor', 'r');
hold on;

%% AdProxGD

arf = AdProxGD(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(2,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;

%% AC-FGM
prob = wrap_func_to_prob(data, 2e-3, x0, tol);  % convert to AC-FGM-compatible
[values, x, num_oracles, total_time] = AC_FGM(prob, 2000, data.L);
semilogy((values-data.f_true)/(values(1)-data.f_true), '-o','Color', colors(3,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%

%% NAGfree
arf = NAGfree(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(4,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;

%% ALSM
%{
[arf,gls] = ALSM(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(5,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold off;
%}

%% Plot Graph
xlim([1, 400]);
ylim([1e-9, 1]);
hold off;
xlabel('Number of Gradient Evaluations'); ylabel('(f(x)-f*)/(f(x_0)-f*)');
legend('A$^2$GD','Line Search Step','AdProxGD','AC-FGM','NAGfree','Interpreter','latex','FontName','Times New Roman','FontSize',18); grid on;
ax = gca;
ax.FontSize = 20;
% legend('A$^2$GD','Grad Eval for Line Search','AdProxGD','NestorovAccGrad', ...
%     'AOR-HB($\mu$)','AOR-HB($\mu/10$)', 'CGdescentStrongWolfe','Grad Eval for Line Search', ...
%     'CGdescentWeakWolfe','Grad Eval for Line Search','Interpreter','latex'); grid on;
% legend('A$^2$GD','Grad Eval for Line Search','AdProxGD','NestorovAccGrad', ...
%     'AOR-HB($\mu$)','AOR-HB($\mu/10$)', 'Linear CG','Interpreter','latex'); grid on;