% This script contains the test of the following smooth convex problem:
% (1) 2-D Laplace linear problem

colors = [0 0.2 0.6; 
      0 0 0;
      0.93 0.69 0.13;
      0.78 0.62 0.78;
      0.85 0.44 0.84;
      0 0.5 0;
      0.56, 0.93, 0.56;
      0.85, 0.33, 0.10;];

%% Example 2'：
data = data_AdultCensusIncome(); n = data.n;
rng(2); x0 = rand(n,1); y0 = rand(n,1); 
max_iters = 2000; tol = 1e-6;
[soln, info] = reference_optimizer(data, 100000, x0, 1e-10);
data.f_true = data.f(soln.x);

%% A2GD_weaklyconvex
figure;
[arf,gls] = A2GD_weaklyconvex(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(1,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
ls = find(gls); vals = arf(ls);
semilogy(ls, vals, 'ro', 'MarkerSize', 2.5, 'MarkerFaceColor', 'r');
hold on;

%% NAG
arf = NAG(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(5,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;

%% AORHB with correct mu
arf = AORHB(x0, y0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(6,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%{
%% AORHB with unprecise mu
data2 = data; data2.mu = data2.mu/10;
arf = AORHB(x0, y0, data2, max_iters, tol);
semilogy(arf, '-o','Color', colors(7,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold on;
%}
%% TM
data.kappa = data.L/data.mu;
arf = TM(x0, data, max_iters, tol);
semilogy(arf, '-o','Color', colors(7,:), 'LineWidth', 0.5, 'MarkerSize', 2);
hold off;
%% Plot Graph
xlim([1, 1000]);
ylim([1e-10, 10]);
hold off;
xlabel('Number of Gradient Evaluations'); ylabel('(f(x)-f*)/(f(x_0)-f*)');
legend('A$^2$GD','Line Search Step','NAG','AORHB','TM','Interpreter','latex','FontName','Times New Roman','FontSize',18); grid on;
ax = gca;
ax.FontSize = 20;
% legend('A$^2$GD','Grad Eval for Line Search','AdProxGD','NestorovAccGrad', ...
%     'AOR-HB($\mu$)','AOR-HB($\mu/10$)', 'CGdescentStrongWolfe','Grad Eval for Line Search', ...
%     'CGdescentWeakWolfe','Grad Eval for Line Search','Interpreter','latex'); grid on;
% legend('A$^2$GD','Grad Eval for Line Search','AdProxGD','NestorovAccGrad', ...
%     'AOR-HB($\mu$)','AOR-HB($\mu/10$)', 'Linear CG','Interpreter','latex'); grid on;