function [soln, info] = reference_optimizer(fun_data, maxIt, x0, tol)

if ~exist('tol', 'var')
    tol = 1e-9;
end

x = x0;
y = x0;
y_old = y;

L = fun_data.L;
k = 1;

res0 = norm(fun_data.gradf(x));
res = res0; % residue

res_lst = zeros(maxIt, 1);
res_lst(k) = res0;
x_lst = zeros(maxIt, length(x));
x_lst(k, :) = x;

f_lst = zeros(maxIt, 1);
f_lst(k) = fun_data.f(x);

while res/res0 > tol && k < maxIt

    y = x - (1/L)*fun_data.gradf(x);

    x = y + (k/(k+3))*(y - y_old);

    y_old = y;


    res = norm(fun_data.gradf(x));
    k = k+1;
    x_lst(k, :) = x;
    res_lst(k) = res;
    f_lst(k) = fun_data.f(x);
    if mod(k,20) == 0
        fprintf('Iter %d, loss %f.\n', k, res/res0);
    end
end


soln = struct('x',x);
info = struct('Ite', k, 'x_lst', x_lst, 'f_lst', f_lst, 'res_lst', res_lst);

end