function prob = wrap_func_to_prob(func, gamma, x0, tol)
    % Wrap the user's func struct into a prob struct used by AC-FGM

    prob.d = func.n;
    prob.gamma = gamma;
    % prob.x_0 = zeros(func.n,1);  % starting point
    prob.x_0 = x0;

    prob.f = func.f;
    prob.gradient = func.gradf;

    prob.first_order_oracle = @(x) deal(func.f(x), func.f(x), func.gradf(x));

    % Prox mapping for L2 regularizer: prox_{ηγ/2 * ||·||^2}(x - ηg)
    % prob.prox_mapping = @(y, g, eta) (y - eta * g) / (1 + 2 * eta * prob.gamma);
    prob.prox_mapping = @(x, g, gamma) sign(x - g) .* max(abs(x - g) - gamma, 0);

    % prob.prox_mapping = @(x,grad,~) x;
    prob.tol = tol;
end
