# Copyright 2023 PKU-Alignment Team. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Raw datasets."""

from safe_rlhf.datasets.raw.alpaca import AlpacaDataset
from safe_rlhf.datasets.raw.firefly import FireflyDataset
from safe_rlhf.datasets.raw.hh_rlhf import (
    HhRLHFDialogueDataset,
    HhRLHFHarmlessDialogueDataset,
    HhRLHFHelpfulDialogueDataset,
)
from safe_rlhf.datasets.raw.moss import MOSS002SFT, MOSS003SFT
from safe_rlhf.datasets.raw.safe_rlhf import (
    SafeRLHF10KTrainDataset,
    SafeRLHF30KTestDataset,
    SafeRLHF30KTrainDataset,
    SafeRLHFDataset,
    SafeRLHFTestDataset,
    SafeRLHFTrainDataset,
)
from safe_rlhf.datasets.raw.safety_llama import (
    SafetyLlamaIAlpacaDataset,
    SafetyLlamaICoNaDataset,
    SafetyLlamaIControversialDataset,
    SafetyLlamaIMaliciousInstructionsDataset,
    SafetyLlamaIPhysicalSafetySafeDataset,
    SafetyLlamaIPhysicalSafetyUnsafeDataset,
    SafetyLlamaQHarmDataset,
    SafetyLlamaXSTestDataset,
    SafetyLlamaAllDataste,
)

from safe_rlhf.datasets.raw.custom_saferlhf import CustomizedSafeRLHFTest, CustomizedSafeRLHFRound0, CustomizedSafeRLHFRound1, CustomizedSafeRLHFRound2

from safe_rlhf.datasets.raw.beaver_trail import BeaverTrailsTrain, BeaverTrailsTest

from safe_rlhf.datasets.raw.potential_saferlhf import PotentialSafeRLHF, PotentialSafeRLHFMostSafe, PotentialSafeRLHFMostUnsafe, PotentialSafeRLHFSimlar

__all__ = [
    'AlpacaDataset',
    'FireflyDataset',
    'HhRLHFDialogueDataset',
    'HhRLHFHarmlessDialogueDataset',
    'HhRLHFHelpfulDialogueDataset',
    'MOSS002SFT',
    'MOSS003SFT',
    'SafeRLHFDataset',
    'SafeRLHFTrainDataset',
    'SafeRLHFTestDataset',
    'SafeRLHF30KTrainDataset',
    'SafeRLHF30KTestDataset',
    'SafeRLHF10KTrainDataset',
    'SafetyLlamaIAlpacaDataset',
    'SafetyLlamaICoNaDataset',
    'SafetyLlamaIControversialDataset',
    'SafetyLlamaIMaliciousInstructionsDataset',
    'SafetyLlamaIPhysicalSafetySafeDataset',
    'SafetyLlamaIPhysicalSafetyUnsafeDataset',
    'SafetyLlamaQHarmDataset',
    'SafetyLlamaXSTestDataset',
    'SafetyLlamaAllDataste',
    'CustomizedSafeRLHFTest',
    'CustomizedSafeRLHFRound0',
    'CustomizedSafeRLHFRound1',
    'CustomizedSafeRLHFRound2',
    'BeaverTrailsTrain',
    'BeaverTrailsTest',
    'PotentialSafeRLHF', 
    'PotentialSafeRLHFMostSafe', 
    'PotentialSafeRLHFMostUnsafe', 
    'PotentialSafeRLHFSimlar',
]