"""
Only prompt dataset from https://github.com/vinid/safety-tuned-llamas/tree/main
Just used to evaluation
"""

from __future__ import annotations

from datasets import load_dataset
from safe_rlhf.datasets.base import RawDataset, RawSample
import json

__all__ = [
    'PotentialSafeRLHF',
    'PotentialSafeRLHFMostUnsafe',
    'PotentialSafeRLHFSimlar',
    'PotentialSafeRLHFMostSafe',
]

class PotentialSafeRLHF(RawDataset):
    
    def __init__(self) -> None:
        with open(self.DATASET_PATH, 'r') as f:
            self.data = json.load(f)
            
    def __getitem__(self, index: int) -> RawSample:
        input = self.data[index]
        return RawSample(input=input, answer="")
    
    def __len__(self) -> int:
        return len(self.data)
    
    

class PotentialSafeRLHFMostUnsafe(PotentialSafeRLHF):
    NAME: str = 'potential-SafeRLHF/most-unsafe'
    DATASET_PATH = '../dataset/PKU-SafeRLHF-potentialans/most-unsafe.json'


class PotentialSafeRLHFSimlar(PotentialSafeRLHF):
    NAME: str = 'potential-SafeRLHF/similar'
    DATASET_PATH = '../dataset/PKU-SafeRLHF-potentialans/similar.json'
    
class PotentialSafeRLHFMostSafe(PotentialSafeRLHF):
    NAME: str = 'potential-SafeRLHF/most-safe'
    DATASET_PATH = '../dataset/PKU-SafeRLHF-potentialans/most-safe.json'