#!/usr/bin/env bash
#
# Copyright 2023 PKU-Alignment Team. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================

if [ -z "${BASH_VERSION}" ]; then
	echo "Please use bash to run this script." >&2
	exit 1
fi

set -x

conda info -e
nvcc -V
nvidia-smi

SCRIPT_DIR="$(cd "$(dirname "$0")" &>/dev/null && pwd)"
ROOT_DIR="$(dirname "${SCRIPT_DIR}")"
export PYTHONPATH="${ROOT_DIR}${PYTHONPATH:+:${PYTHONPATH}}"

# RED_CORNER_MODEL_NAME_OR_PATH="../model/alpaca-7b-reproduced"
# RED_CORNER_MODEL_NAME_OR_PATH="../output/beaver-v1"

RED_CORNER_MODEL_NAME_OR_PATH="../output/beaverdiffaclr-v1"
BLUE_CORNER_MODEL_NAME_OR_PATH="../output/beaver-v1"
REWARD_MODEL_NAME_OR_PATH="../model/beaver-7b-v1.0-reward"
COST_MODEL_NAME_OR_PATH="../model/beaver-7b-v1.0-cost"
OUTPUT_DIR="../output/evaluation/test"
while [[ "$#" -gt 0 ]]; do
	arg="$1"
	shift
	case "${arg}" in
		--red_corner_model_name_or_path)
			RED_CORNER_MODEL_NAME_OR_PATH="$1"
			shift
			;;
		--red_corner_model_name_or_path=*)
			RED_CORNER_MODEL_NAME_OR_PATH="${arg#*=}"
			;;
		--blue_corner_model_name_or_path)
			BLUE_CORNER_MODEL_NAME_OR_PATH="$1"
			shift
			;;
		--blue_corner_model_name_or_path=*)
			BLUE_CORNER_MODEL_NAME_OR_PATH="${arg#*=}"
			;;
		--reward_model_name_or_path)
			REWARD_MODEL_NAME_OR_PATH="$1"
			shift
			;;
		--reward_model_name_or_path=*)
			REWARD_MODEL_NAME_OR_PATH="${arg#*=}"
			;;
		--cost_model_name_or_path)
			COST_MODEL_NAME_OR_PATH="$1"
			shift
			;;
		--cost_model_name_or_path=*)
			COST_MODEL_NAME_OR_PATH="${arg#*=}"
			;;
		--output_dir)
			OUTPUT_DIR="$1"
			shift
			;;
		--output_dir=*)
			OUTPUT_DIR="${arg#*=}"
			;;
		*)
			echo "Unknown parameter passed: '${arg}'" >&2
			exit 1
			;;
	esac
done

mkdir -p "${OUTPUT_DIR}"
OUTPUT_DIR="$(cd "${OUTPUT_DIR}" &>/dev/null && pwd)"
if [[ ! -f "${OUTPUT_DIR}/.gitignore" ]]; then
	echo '*' >"${OUTPUT_DIR}/.gitignore"
fi

cp -f "$0" "${OUTPUT_DIR}/script.sh"

exec 1> >(tee "${OUTPUT_DIR}/stdout.log" >&1) 2> >(tee "${OUTPUT_DIR}/stderr.log" >&2)

python3 -m safe_rlhf.evaluate.pipe_arena \
	--datasets PKU-SafeRLHF/test \
	--red_corner_model_name_or_path "${RED_CORNER_MODEL_NAME_OR_PATH}" \
	--blue_corner_model_name_or_path "${BLUE_CORNER_MODEL_NAME_OR_PATH}" \
	--reward_model_name_or_path "${REWARD_MODEL_NAME_OR_PATH}" \
	--cost_model_name_or_path "${COST_MODEL_NAME_OR_PATH}" \
	--output_dir "${OUTPUT_DIR}"
