conda info -e
nvcc -V
nvidia-smi

python -m safe_rlhf.evaluate.generate \
    --corner_model_name_or_path ../output/Llama-3.2-3B-sft-alpaca-saferlhf\
    --datasets safety-llama/all \
    --num_per_prompt 1 \
    --max_length 512 \
    --output_dir ../outputdata/generate/safety-llama/

python -m safe_rlhf.evaluate.generate \
    --corner_model_name_or_path ../output/Llama-3.2-3B-sft-alpaca-saferlhf\
    --datasets PKU-SafeRLHF/test \
    --num_per_prompt 1 \
    --max_length 512 \
    --output_dir ../outputdata/generate/pku/

python -m safe_rlhf.evaluate.model_eval_reward \
    --response_path ../outputdata/generate/pku/Llama-3.2-3B-sft-alpaca-saferlhf_1.json \
    --reward_model_name_or_path ../model/beaver-7b-v1.0-reward \
    --output_dir ../outputdata/model_eval/pku/reward/

python -m safe_rlhf.evaluate.model_eval_cost \
    --response_path ../outputdata/generate/pku/Llama-3.2-3B-sft-alpaca-saferlhf_1.json \
    --cost_model_name_or_path ../model/beaver-7b-v1.0-cost \
    --output_dir ../outputdata/model_eval/pku/cost/

python -m safe_rlhf.evaluate.model_eval_reward \
    --response_path ../outputdata/generate/safety-llama/Llama-3.2-3B-sft-alpaca-saferlhf_1.json \
    --reward_model_name_or_path ../model/beaver-7b-v1.0-reward \
    --output_dir ../outputdata/model_eval/safety-llama/reward/

python -m safe_rlhf.evaluate.model_eval_cost \
    --response_path ../outputdata/generate/safety-llama/Llama-3.2-3B-sft-alpaca-saferlhf_1.json \
	--cost_model_name_or_path ../model/beaver-7b-v1.0-cost \
    --output_dir ../outputdata/model_eval/safety-llama/cost/