#include "IterativeGreedy.h"
#include "Constants.h"
#include <algorithm>
#include "HeapData.hpp"
#include "mappedheap.hpp"

using namespace std;

IterativeGreedy::IterativeGreedy(Network * g) : QoSalgorithm(g)
{
}


IterativeGreedy::~IterativeGreedy()
{
}

//ALG3 + ALG1
int IterativeGreedy::getSolution()
{
	int re = 0;
	while (!isCut()) {
		re = 0;
		int upper = potentialPaths.size() * Constants::T;
		g->resetCurrentWeight();

		initiateEdges();
		vector<int> edgeIds;
		for (int i = 0; i < listEdges.size(); i++) {
			edgeIds.push_back(i);
		}

		vector<int> length(pathLengths);
		vector<int> marginalGain(initialMarginalGain);

		DescendingOrder<int> hd(&marginalGain[0]);
		MappedHeap<DescendingOrder<int>> heap(edgeIds, hd);
		int delay = overallDelay;
		vector<map<int, int>> up(increaseDelay);

		while (delay < upper) {
			int edgeId = heap.top();
			pair<int, int> tmp = listEdges[edgeId];

			if (g->reachMaxLevel(tmp.first, tmp.second)) {
				heap.pop();
				continue;
			}

			int gain = marginalGain[edgeId];
			delay += gain;
			re++;
			g->increaseQoSlevel(tmp.first, tmp.second);
			
			int nextDelay = g->getIncreasingDelayOfEdge(tmp.first, tmp.second);
			marginalGain[edgeId] = 0;
			heap.heapify(edgeId);

			vector<int> tmpPaths = relatedPaths[edgeId];
			

			#pragma omp parallel for
			for (int i = 0; i < tmpPaths.size(); ++i) {
				int pathId = tmpPaths[i];
				length[pathId] += up[pathId][edgeId];
				vector<int> tmpEdges = paths[pathId];
				
				for (int j = 0; j < tmpEdges.size(); ++j) {
					int e = tmpEdges[j];
					if (e != edgeId) {
						int oldValue = up[pathId][e];
						int newValue = min(Constants::T - length[pathId], oldValue);
						if (oldValue != newValue) {
							up[pathId][e] = newValue;
							#pragma omp critical
							{
								marginalGain[e] -= oldValue - newValue;
								heap.heapify(e);
							}
						}
					}
					else {
						int newValue = min(Constants::T - length[pathId], nextDelay);
						up[pathId][e] = newValue;
						#pragma omp critical
						{
							marginalGain[edgeId] += newValue;
							heap.heapify(e);
						}
					}
				}
			}
		}
	}
	
	return re;
}

//Algorithm 2
bool IterativeGreedy::isCut()
{
	vector<pair<int, int>> * transactions = g->getListOfTransaction();
	int tmp = potentialPaths.size();

	#pragma omp parallel for
	for (int i = 0; i < transactions->size(); ++i) {
		map<int, map<int, bool>> excludedEdges;
		int sId = (*transactions)[i].first;
		int eId = (*transactions)[i].second;
		int length = 0;
		
		vector<vector<int>> paths;
		g->shortestPaths(sId, eId, &paths);
		if (paths.size() > 0) {
			for (int j = 0; j < paths.size(); ++j) {
			int initalLength = g->getInitialLength(&paths[j]);
				#pragma omp critical
				{
					potentialPaths.push_back(pair<int, vector<int>>(initalLength, paths[j]));
					//g->printPath(paths[j]);
				}
			}
		}
	}
	return (tmp == potentialPaths.size());
}

void IterativeGreedy::initiateEdges()
{
	int id = listEdges.size();
	for (int i = potentialId; i < potentialPaths.size(); ++i) {
		paths.push_back(vector<int>());
		increaseDelay.push_back(map<int, int>());
		vector<int> path = potentialPaths[i].second;
		int length = potentialPaths[i].first;
		pathLengths.push_back(length);
		overallDelay += length;
		
		for (int j = 0; j < path.size() - 1; ++j) {
			int startId = path[j];
			int endId = path[j + 1];
			map<int, int> tmp = mapPairNodes2EdgeId[startId];
			int gain = min(g->getIncreasingDelayOfEdge(startId, endId), Constants::T - length);
			
			if (tmp.find(endId) == tmp.end()) {
				listEdges.push_back(pair<int, int>(startId, endId));
				mapPairNodes2EdgeId[startId][endId] = id;
				if (!g->isDirectedGraph())
					mapPairNodes2EdgeId[endId][startId] = id;
				relatedPaths.push_back(vector<int>());
				relatedPaths[id].push_back(i);
				paths[i].push_back(id);
				increaseDelay[i][id] = gain;
				++id;
				initialMarginalGain.push_back(gain);
			}
			else {
				int edgeId = tmp[endId];
				paths[i].push_back(edgeId);
				increaseDelay[i][edgeId] = gain;
				initialMarginalGain[edgeId] += gain;
				relatedPaths[edgeId].push_back(i);
			}
		}
	}

	potentialId = potentialPaths.size();
}
