#include<iostream>
#include <omp.h>
#include <time.h>
#include <fstream>
#include <stdlib.h>
#include <string>
#include "Network.h"
#include "IterativeGreedy.h"
#include "Constants.h"
#include "SamplingAlgorithm.h"
#include "LinearRounding.h"
#include "LinearPartition.h"
#include "TrunkAdding.h"
#include <time.h>

using namespace std;

#pragma warning(disable: 4996) 

Network * g;
ofstream writefile;

void printResult(bool isDirected, int delayFunction, int noNodes = 1, double p = 0.1, int change = 1) {
	if (change == 3) {
		g->generateRandomNetwork(noNodes, p, isDirected);
		g->generateTransaction();
	}
	Constants::MAX_LEVEL = QoScommon::getInstance()->getMaxLevel(Constants::DELAY_FUNC, Constants::T);
	cout<<"start IG"<<endl;
	g->resetCurrentWeight();
	IterativeGreedy ig(g);
	long startIg = time(NULL);
	int reIg = ig.getSolution();
	long timeIg = time(NULL) - startIg;
	g->printCurrentQoSlevel("result/IG_"+to_string(Constants::T)+".csv");
	writefile << Constants::T<<","<<Constants::NUMBER_OF_TRANSACTIONS<<",IG," <<reIg <<","<< timeIg <<endl;
	cout << "IG: " << reIg << " " << timeIg << endl;

	// cout<<"Start SA"<<endl;
	// g->resetCurrentWeight();
	// SamplingAlgorithm sa(g);
	// long startSa = time(NULL);
	// int reSa = sa.getSolution();
	// long timeSa = time(NULL) - startSa;
	// g->printCurrentQoSlevel("result/SA_"+to_string(Constants::T)+".csv");
	// writefile << Constants::T<<","<<Constants::NUMBER_OF_TRANSACTIONS<<",SA," <<reSa <<","<< timeSa <<endl;
	// cout << "SA: " << reSa << " " << timeSa << endl;

	// g->resetCurrentWeight();
	// cout << "start AT" << endl;
	// TrunkAdding ta(g);
	// long startTa = time(NULL);
	// int reTa = ta.getSolution();
	// long timeTa = time(NULL) - startTa;
	// g->printCurrentQoSlevel("result/AT_"+to_string(Constants::T)+".csv");
	// writefile << Constants::T<<","<<Constants::NUMBER_OF_TRANSACTIONS<<",AT," <<reTa <<","<< timeTa <<endl;
	// cout << "AT: " << reTa << " " << timeTa << endl;

	// int reLr, reLp;
	// if (delayFunction == 1 || delayFunction == 5) {
	// 	cout<<"start LP"<<endl;
	// 	g->resetCurrentWeight();
	// 	LinearRounding lr(g);
	// 	long startLr = time(NULL);
	// 	reLr = lr.getSolution();
	// 	long timeLr = time(NULL) - startLr;
	// 	g->printCurrentQoSlevel("result/LP_"+to_string(Constants::T)+".csv");
	// 	writefile << Constants::T<<","<<Constants::NUMBER_OF_TRANSACTIONS<<",LP," <<reLr <<","<< timeLr <<endl;
	// 	cout << "LR: " << reLr << " " << timeLr << endl;		
	// }
	writefile << endl;
}

void runExperiment(int numberOfNodes, string file, bool isDirected, int delayFunction, 
	int change = 1, int min = 24, int max = 48, int step = 2, bool isLargeFile = false, 
	bool isRandomGraph = false) { 

	Constants::T = 24;
	Constants::NUMBER_OF_TRANSACTIONS = 100;
	Constants::DELAY_FUNC = delayFunction;
	Constants::IS_LARGE_NETWORK = isLargeFile;

	if (!isRandomGraph) {
		if (isLargeFile)
		{
			g->readNetworkLargeFile(numberOfNodes, "data/" + file, isDirected);
			g->readTransactionsFromFile("data/pairs_" + file);
		}
		else
		{
			g->readNetworkFromFile(numberOfNodes, "data/" + file, isDirected);
			g->readTransactionsFromFile("data/pairs_" + file);
		}
	}

	string outfilename = "result/" + file + "_"
		+ (isDirected ? "directed" : "undirected")
		+ "_delay" + to_string(delayFunction) 
		+ "_" + (change == 1? "changeT" : change == 2? "changeK" : "changeP") + ".txt";

	writefile.open(outfilename);
	if (writefile.is_open()) {
		if (change == 3) writefile << "p \t";

		writefile << "Threshold T,Number of pairs,ALG,Solution,Running time(s)"<<endl;

		if (change == 1) {
			for (Constants::T = min; Constants::T <= max; Constants::T += step) {
				cout<<"T: "<<Constants::T<<endl;
				printResult(isDirected, delayFunction);
			}
		}
		else if (change == 2) {
			for (Constants::NUMBER_OF_TRANSACTIONS = min; Constants::NUMBER_OF_TRANSACTIONS <= max; Constants::NUMBER_OF_TRANSACTIONS += step) {
				printResult(isDirected, delayFunction);
			}
		}
		else if (change == 3) {
			Constants::T =  3;
			for (double p = 0.1; p <= 1.0; p += 0.1) {
				printResult(isDirected, delayFunction, numberOfNodes, p, change);
			}
		}

		writefile.close();
	}else {
		cout << "Error on openning file to write result" << endl;
	}

}

int main() {
	omp_set_num_threads(Constants::NUM_THREAD);
	g = new Network();
	cout<<"start"<<endl;

	// runExperiment(1024, "Synthetic.txt", true, 1, 1, 10, 20, 1, false, false);
	// runExperiment(1005, "Email.txt", true, 1, 1, 11, 25, 1, false, false);
	// runExperiment(6301, "Gnutella08.txt", true, 1, 1, 24, 160, 5, false, false);
	runExperiment(1965206, "roadNetCA.txt", false, 1, 1, 186, 186, 1, false, false);

	// runExperiment(6301, "Gnutella08.txt", true, 1, 1, 15, 160, 5,false,false);
	//runExperiment(10876, "p2p-Gnutella04.txt", true, 4, 1, 10, 50, 5,false,false);

	//runExperiment(1696415, "as-skitter.txt", false, 4, 1, 5, 12, 1, true,false);

	//runExperiment(1965206, "roadNet-CA.txt", false, 1, 1, 100, 120, 2, true,false);
	//runExperiment(1965206, "roadNet-CA.txt", false, 4, 1, 70, 100, 3, true,false);
	//runExperiment(1965206, "roadNet-CA.txt", false, 5, 1, 70, 100, 3, true,false);

	return 0;
}