#!/bin/bash
#SBATCH --ntasks=1
#SBATCH --time=10:00:00
#SBATCH --mem=0
#SBATCH --partition=gpu
#SBATCH --gres=gpu:v100:1


module load gcc
module load python/3.7.6
module load cuda/11.1-1
module load cudnn/8.0.4.30-11.1



### DEMO code for extracting features from supervised model, constructing NNK graphs, getting diamter metric

## numer_transformations should be max 350 for single gpu
N_TRANSFORMATIONS=50


DATA_PATH='/datasets/imagenet/'
LOG_DIR='/logs/NNK_augmentation_eval'
WEIGHTS_SUPERVISED='/torch_hub/checkpoints/resnet50-11ad3fa6.pth'
MODEL_NAME_SUPERVISED='supervised'
TRANSFORM_TYPE='none'



python encoder_feature_extract.py --log_dir $LOG_DIR --data_path $DATA_PATH --model_name $MODEL_NAME_SUPERVISED \
	 --checkpoint_key model --n_augmentations $N_TRANSFORMATIONS --transform_type $TRANSFORM_TYPE --trained \
                    --pretrained_weights $WEIGHTS_SUPERVISED

## Save graphs 
python multiple_nnk_analysis_subspace.py --log_dir $LOG_DIR \
		--model $MODEL_NAME_SUPERVISED --type_transfo $TRANSFORM_TYPE --layer backbone_features \
		--extract_analysis get_graph --trained

## Get diameter - Invariance/equivariance metric
python multiple_nnk_analysis_subspace.py --log_dir $LOG_DIR \
		$MODEL_NAME_SUPERVISED --type_transfo $TRANSFORM_TYPE --layer backbone_features \
		--extract_analysis get_diam --trained
