# Control with Patterns: A D-learning Method

## Training Script

The version of `Python` is `3.8.19`.

Before running, please `pip install jupyter` and `pip install -r requirements.txt`.

And run `jupyter notebook train_cwp_image_servo.ipynb`.

## Datasets

Unzip `flight_data_metric.7z` into the folder `flight_data_metric`.

Filenames of datasets are obtained on the simulation platform and structured as

```
./flight_data_metric/cwp_dataengine_<DATA_INDEX>.csv
```

Available fields are given in the following table.

| `field` | description |
|---------|-------------|
| `mav_pos_<x,y,z>` | position vector in meters |
| `mav_vel_<x,y,z>` | velocity vector in m/s |
| `mav_<yaw,pitch,roll>` | attitude represented as Euler angle in rad |
| `mav_<yaw,pitch,roll>_rate` | angular velocity in rad/s |
| `delta_<u,v>` | tracking error |
| `init_pos_<x,y,z>` | initial position of multicopter |
| `timestamp` | timestamp |
| `encoding_<1-32>` | encoding from real-time image |

