import numpy as np
from dm_env.specs import Array, BoundedArray
from acme.specs import EnvironmentSpec


def sawyer_specs():
    obs_dim = 12288
    max_episode_steps = 151
    specs = EnvironmentSpec(
        observations=BoundedArray(shape=(24576,), dtype=np.uint8, name='state', minimum=np.zeros(24576, dtype=np.uint8), maximum=255*np.ones(24576, dtype=np.uint8)),
        actions=BoundedArray(shape=(4,), dtype=np.float32, name='action', minimum=-1*np.ones(4, dtype=np.float32), maximum=np.ones(4, dtype=np.float32)),
        rewards=Array(shape=(), dtype=np.float64, name='reward'),
        discounts=BoundedArray(shape=(), dtype=np.float64, name='discount', minimum=0.0, maximum=1.0))
    return obs_dim, max_episode_steps, specs