#!/bin/bash

set -euo pipefail

VARIANTS=$(seq 0 5)
DATE=$(date +%y%m%d)

for variant_suffix in ${VARIANTS[@]}; do
    var="v${variant_suffix}"
    python -m apps.gnn_explainer.gaston_sgm \
        --key=${var} \
        --output-dir=dataset/data/gaston_annotated/${DATE}/ba-shapes-${var} \
        --input-file=dataset/data//ba-shapes-7000/ba-shapes-${var}/ba_3000_800-0001.json \
        --data-root=~/ws/data
done
