from torch import cuda


def cuda_description() -> str:
    desc = f'CUDA available: {cuda.is_available()}, count: {cuda.device_count()}, '
    desc += f'current device: {cuda.current_device()}'
    for n in range(cuda.device_count()):
        desc += f', Device: {cuda.get_device_name(n)}'
    return desc
