#!/usr/bin/env bash

if [ $# -ne 1 ]; then
    echo "Please run as $0 <variant> (variant: m1, m1p, m1pp, m2, m2p, m2pp)"
    exit 1
fi

var=
if [ $1 == "m1" ]; then
    var='p001-01'
elif [ $1 == "m1p" ]; then
    var='p001-02'
elif [ $1 == "m1pp" ]; then
    var='p001-03'
elif [ $1 == "m2" ]; then
    var='p007-02'
elif [ $1 == "m2p" ]; then
    var='p008-02'
elif [ $1 == "m2pp" ]; then
    var='p009-02'
fi

curr_dir=$(realpath $(dirname $0))
echo "Current dir: ${curr_dir}"
export PYTHONPATH=$curr_dir:$curr_dir/apps/gnn_explainer
export GASTON_BIN_PATH=${curr_dir}/external/gaston

config_file="run_configs/${var}.yml"
echo "Running variant $1"
set -x
python -m workflows.run --config=${config_file} 2>&1
{ set +x; } > /dev/null
