import logging

import networkx as nx

LOG = logging.getLogger(__name__)


class GroundTruthMaker:
    ...


class HouseMaker(GroundTruthMaker):
    def __init__(self, total: int, random_node_count: int):
        self._total: int = total
        self._random_count: int = random_node_count

    def make_house(self, m0: int) -> nx.Graph:
        assert m0 >= self._random_count
        G = nx.Graph()
        G.add_edges_from(
            (
                (m0, m0 + 1),
                (m0 + 1, m0 + 2),
                (m0 + 2, m0 + 3),
                (m0 + 3, m0),
                (m0, m0 + 4),
                (m0 + 1, m0 + 4),
            )
        )
        return G

    def make_house_with_handle(self, m0: int, handle_ids: int):
        G = self.make_house(m0)
        for handle_id in handle_ids:
            G.add_edge(m0, handle_id)
        return G
