from typing import Tuple

import networkx as nx
from networkx.algorithms.isomorphism import ISMAGS

from egr.fsg import gaston
from egr.graph_utils import get_neighborhood_subgraph
from egr.util import load_indices, load_labels, to_dict, load_graph


def root_matcher(n1: str, n2: str) -> bool:
    return (gaston.rootAttr in n1) == (gaston.rootAttr in n2)


def is_isomorphic(G1: nx.Graph, G2: nx.Graph) -> bool:
    iso = ISMAGS(G1, G2, node_match=root_matcher)
    return iso.subgraph_is_isomorphic()


class SubgraphIsomorphism:
    def __init__(self, G, G_s):
        self.G = G
        self.G_s = G_s
        self.diameter = min(nx.diameter(self.G_s), 3)

    def is_isomorphic(self, index: int, n: int) -> Tuple[int, bool]:
        G = get_neighborhood_subgraph(self.G.copy(), index, self.diameter)
        gaston.makeRootNode(G, index)
        return n, is_isomorphic(G, self.G_s.copy())

    # def is_isomorphic(self, index: int) -> bool:
    #     G = get_neighborhood_subgraph(self.G.copy(), index, self.diameter)
    #     gaston.makeRootNode(G, index)
    #     return is_isomorphic(G, self.G_s.copy())
