from __future__ import annotations
import json

import logging
import yaml
from pathlib import Path
from typing import Dict

from egr.util import to_string

LOG = logging.getLogger(__name__)


class Config:
    @classmethod
    def load(cls, path: Path) -> Config:
        cfg_data: Dict = yaml.safe_load(path.open())
        try:
            if 'paths' in cfg_data:
                for k, v in cfg_data['paths'].items():
                    cfg_data.update({k: Path(v).expanduser().absolute()})
            cfg: Config = cls()
            cfg.__dict__.update(**cfg_data)
            return cfg
        except TypeError as err:
            LOG.error('%s %s', err, [x for x in cfg_data])

    def __str__(self):
        return to_string(self.__dict__)
