# %%
import numpy as np
from scipy.stats import truncnorm

trun_min = 1
trun_mid = 4
trun_max = 10

def cdf0_twomode(x):
    x = np.asarray(x)
    y = np.ones_like(x) 
    
    y[x <= trun_min] = 0
    mask1 = (x > trun_min) & (x <= trun_mid)
    y[mask1] = 0.5 * (x[mask1] - trun_min) / (trun_mid - trun_min)
    mask2 = (x > trun_mid) & (x <= trun_max)
    y[mask2] = 0.5 + 0.5 * (x[mask2] - trun_mid) / (trun_max - trun_mid)
    
    return y


def cdf0_tnorm1(x, sd=0.1):
    x = np.asarray(x)

    p1 = truncnorm.cdf(x, (trun_min - (trun_min + trun_mid)/2) / sd, 
                           (trun_max - (trun_min + trun_mid)/2) / sd, 
                           loc=(trun_min + trun_mid)/2, scale=sd)
    
    p2 = truncnorm.cdf(x, (trun_min - (trun_mid + trun_max)/2) / sd, 
                           (trun_max - (trun_mid + trun_max)/2) / sd, 
                           loc=(trun_mid + trun_max)/2, scale=sd)
    
    return 0.75 * p1 + 0.25 * p2


def cdf0_tnorm2(x, sd=0.5):
    return cdf0_tnorm1(x, sd=sd)


# generate covariate X
def gen_x_unif(n, d, seed=None):
    radius = 1 / 2
    if seed is not None:
        np.random.seed(seed)
    
    random_directions = np.random.normal(size=(n, d))
    random_directions = random_directions / np.sqrt(np.sum(random_directions**2, axis=1, keepdims=True)) 
    
    random_radii = np.random.uniform(size=n)**(1/d)  

    return radius * (random_directions * random_radii[:, np.newaxis])


def cdf_ph(cdf0, u, v):
    """
    cdf0: baseline cdf
    u: input part
    v: x^T beta part
    """
    return 1 - (1 - cdf0(u))**(np.exp(v))
