# Cumulative Regret Experiments

This repository contains code to reproduce numerical experiments for BayesCoxCP and CoxCP. It includes two main method implementations—`BayesCoxCP` (Python) and `CoxCP` (R)—and scripts to simulate, fit, and plot cumulative regrets.

## Repository Structure

```
├── BayesCoxCP/              # Python implementation of BayesCoxCP
│   ├── BayesCoxCP_main.py   # Entry-point: tuning & fitting for BayesCoxCP
│   ├── BayesCoxCP_simul.py  # Simulation & fitting class for BayesCoxCP
│   ├── CoxVB.py             # Variational Bayes for Cox PH model
│   └── DGP.py               # Data generating processes (baseline CDF & covariates)

├── CoxCP/                   # R implementation of CoxCP proposed by Choi et al. (2023)
│   ├── CoxCP_main.R         # Entry-point: tuning & fitting for CoxCP
│   ├── CoxCP_simul.R        # Simulation & fitting in R
│   └── CoxCP_DGP.R          # Data generating processes

├── plot_results.py          # Python script to plot results from both methods
├── README.md                # This file
└── requirements.txt         # Requirements file for Python implementation
```

## Requirements

### Python

Install required packages:
```bash
pip install -r requirements.txt
```

### R

Install the following package: `icenReg` (for interval censored data; install via `install.packages('icenReg)`)

## Execution Guide

### 1. BayesCoxCP (Python)

Install Python dependencies, then:

```bash
cd BayesCoxCP
python BayesCoxCP_main.py \
  --nrepl 20 \
  --TH 30000 \
  --TH_tuning 3000 \
  --tuning \
  --save_dir result
```

Options:

* `--nrepl`: number of replications (default: 20)
* `--TH`: time horizon for main fitting (default: 30000)
* `--TH_tuning`: time horizon for tuning (default: 3000)
* `--tuning`: flag to perform hyperparameter tuning
* `--ngrid_list`: list of grid sizes
* Other grid settings: `--cdf0str_list`, `--covstr_list`, `--xstr_list`

Outputs are saved under `save_dir`.

### 2. CoxCP (R)

Install R packages and run:

```r
setwd("CoxCP")
source("CoxCP_main.R")
```

Outputs are saved under `result`.

### 3. Plotting (Python)

After both methods finish, run:

```bash
python plot_results.py \
  --nrepl 20 \
  --TH 30000 \
  --load_dir result \
  --save_dir exp_result
```

This script reads CSVs from `BayesCoxCP/result` and `CoxCP/result`, computes mean & std of cumulative regret, and saves comparative plots in `exp_result`.

