# What is Important? Internal Interpretability of Models Processing Data with Inherent Structure

Source code and demo for What is Important? 
Internal Interpretability of Models Processing Data with Inherent Structure. 

>![Demo](demo.png)

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

>📋  All datasets except imagenet are automatically downloaded to `data/` dir during training or inference. For imagenet set `IMAGENET_PATH` env variable with path to imagenet root dir.

## Training

To train the model(s) in the paper, run this command:

```train
python train.py --dataset pets --model_type ba --embedding_size 128 --patch_size 16
```

>📋  All parameters of train can be accesed using `python train.py --help
` For FA and RA you need to specify `--checkpoint-path`. Additionally, for RA, the `--threshold` parameter is required.

## Pre-trained Models

You can download pretrained models [here](https://drive.proton.me/urls/KHVE86HJ4W#ZAaoUEtgCEYx), please put them in the `checkpoints` directory.