from torchvision import datasets


class Cars(datasets.StanfordCars):
    def __init__(self, root, split='train', transform=None):
        self.root = root
        super().__init__(root=root, split=split, transform=transform, download=True)

    def __getitem__(self, index: int):
        image, label = super().__getitem__(index)
        return {
            'x': image,
            'y': label,
        }

    def download(self):
        if not self._check_exists():
            import kaggle
            kaggle.api.dataset_download_files('rickyyyyyyy/torchvision-stanford-cars', path=self.root, unzip=True)