import torch
from torchvision import datasets
from torchvision.datasets.utils import download_and_extract_archive


class Imagenette(datasets.Imagenette):
    def __init__(self, root, split='train', transform=None):
        super().__init__(root=root, split=split, transform=transform, download=True)

    def _download(self):
        if self._check_exists():
            return

        download_and_extract_archive(self._url, self.root, md5=self._md5)

    def __getitem__(self, index):
        # Get the image and label using the parent class's method
        image, label = super().__getitem__(index)

        # Return as a dictionary
        return {'x': image, 'y': label}
