import os
import boto3
import pandas as pd
import time
import json
from botocore.exceptions import ClientError


session = boto3.Session(profile_name='default')
# Create an Amazon Bedrock Runtime client
brt = session.client("bedrock-runtime", region_name="us-east-1") #utility

model_id = "anthropic.claude-3-5-sonnet-20240620-v1:0"
#model_id = "meta.llama3-3-70b-instruct-v1:0"

# Model configurations
model_config = {
    "anthropic.claude-3-5-sonnet-20240620-v1:0": {
        "role": "user",
        "inference_config": {
            "maxTokens": # placeholder — exact value omitted and will be included upon paper acceptance,
            "topP": # placeholder — exact value omitted and will be included upon paper acceptance

        }
    }
}

# Extract text between tags
def extract_between_tags(text, start_tag, end_tag):
    try:
        start_idx = text.find(start_tag)
        end_idx = text.find(end_tag)
        if start_idx != -1 and end_idx != -1:
            return text[start_idx + len(start_tag):end_idx].strip()
        return "Not found"
    except Exception as e:
        print(f"Error extracting between tags '{start_tag}' and '{end_tag}': {e}")
        return "Not found"


def call_bedrock(prompt):
    # Send the message to the model

    config = model_config[model_id]
    conversation = [{"role": config["role"], "content": [{"text": prompt}]}]

    response_text = ""
    while response_text == "":
        try:
            response = brt.converse(
                modelId=model_id,
                messages=conversation,
                inferenceConfig=config["inference_config"],
            )
            response_text = response["output"]["message"]["content"][0]["text"]
            print(f"Full response for model {model_id}:\n{response_text}\n")
        except (ClientError, Exception) as e:
            print(f"ERROR: Can't invoke '{model_id}'. Reason: {e}")
            print('Sleeping')
            time.sleep(5)
    
    return response_text













