# ERA: Evidence-Based Reasoning and Augmentation for Open-Vocabulary Medical Vision

## Framework Overview

The ERA framework operates on a multi-stage pipeline. It first retrieves relevant visual evidence from a pre-built medical knowledge base. Based on the quality of the retrieved evidence, it employs one of several strategies—from direct mapping to deliberative reasoning—to generate a high-confidence bounding box. This box is then passed to SAM2 to produce the final, precise segmentation mask.



## Key Features

- **Evidence-Based Reasoning**: Utilizes a RAG pipeline for more reliable localization.
- **Modular Design**: Decouples the reasoning engine from the final segmentation model (SAM2).
- **Zero-Shot Capability**: Performs open-vocabulary segmentation without task-specific training.
- **Configurable**: Easily adaptable via a central YAML configuration file.

## Qualitative Results

The ERA framework demonstrates superior segmentation performance compared to existing zero-shot generalist models, especially in specialized medical domains. The figure below highlights the catastrophic failure of baselines on MSD and BraTS datasets, where they produce unstructured noise, while ERA consistently reconstructs coherent and anatomically plausible shapes.

## Setup and Installation

1.  **Clone the Repository:**
    
2.  **Create Environment & Install Dependencies:**
    It is recommended to use a virtual environment 
    
    ```bash
    conda create -n era python=3.9
    conda activate era
    pip install -r requirements.txt
    ```
    
3.  **Download Models:**
    Download the required pre-trained models and place them in a designated `models` directory (or any other location, and update the paths in the config file).
    - **Qwen2.5-VL**: `Qwen/Qwen2.5-VL-7B-Instruct`
    - **SAM2**: `sam2/sam2.1_hiera_base_plus.pt`
    - **BLIP**: Handled automatically by the `lavis` library during the first run.

4.  **Prepare Knowledge Base:**
    Place your pre-computed knowledge base (`unified_medical_kb.json`) and feature matrix (`medical_features.npz`) into a designated directory.

## Usage

1.  **Prepare Data:**
    Place your input images in the folder specified by `input_image_dir` in the config file.

2.  **Configure Paths:**
    Open `configs/config.yaml` and update all path variables under `data_paths` and `model_configs` to match your local environment.

3.  **Run Inference:**
    ```bash
    python main.py
    ```
    Results, logs, and visualizations will be saved to the directories specified in `config.yaml`.

## Configuration

All operational parameters, including file paths, model configurations, and reasoning thresholds, can be adjusted in `configs/config.yaml`.



> **This project folder only contains partial implementation code of the entire project. More information will be open-sourced on GitHub after admission.**
